import os, subprocess, shlex, tempfile

AFTER_EFFECTS_APP = "Adobe After Effects 2025"

PROJECT   = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/Scoring Animation 3.aep"
CSV_PATH  = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/teams_rgb_correct.csv"
JSX_BATCH = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/batch_score_animation_3.jsx"
COMMON_JSX= "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/gl_common.jsxinc"

COMP        = "Comp 2"
ANIM_NAME   = "TD_2_6"

OUTDIR        = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/TD_Animation_3_384"
PATH_TEMPLATE = "{league}"
OM_TEMPLATE   = "H.264 - Match Source - High Bitrate"
EXT           = ".mp4"

RUN_MODE = "league"      # or "subset"
LEAGUE   = "NFL"
SUBSET   = ["BUF","DAL","PHI"]

def _write_bridge_jsx(env):
    def esc(s): return s.replace("\\","\\\\").replace('"','\\"')
    lines = [ '$.setenv("'+esc(k)+'","'+esc(str(v))+'");' for k,v in env.items() ]
    lines.append('$.evalFile(File("'+esc(JSX_BATCH)+'"));')
    code = "\n".join(lines)+"\n"
    tmp = tempfile.NamedTemporaryFile(prefix="ae_bridge_", suffix=".jsx", delete=False)
    tmp.write(code.encode("utf-8")); tmp.flush(); tmp.close()
    return tmp.name

def run(env):
    os.makedirs(OUTDIR, exist_ok=True)
    bridge = _write_bridge_jsx(env)
    osa = [
        "osascript",
        "-e", f'tell application "{AFTER_EFFECTS_APP}" to activate',
        "-e", f'tell application "{AFTER_EFFECTS_APP}" to DoScriptFile POSIX file "{bridge}"',
    ]
    print("Running:", " ".join(shlex.quote(c) for c in osa))
    subprocess.run(osa, check=True)

def make_env(league=None, teams=None):
    env = {
        "AE_PROJECT": PROJECT,
        "AE_CSV": CSV_PATH,
        "AE_COMMON_JSX": COMMON_JSX,
        "AE_COMP": COMP,

        "AE_TEXT_STROKE_LAYER": "TOUCHDOWN",
        "AE_TD_PRECOMP_LAYER":  "TD PreComp",
        "AE_TEAMNAME_LAYER":    "TeamName",
        "AE_SOLID_LAYER": "Solid",

        "AE_PURGE_BEFORE_RENDER": "1",

        # Leave blank to avoid changing widths; set "2" if you want fixed width
        "AE_STROKE_WIDTH": "",
        "AE_STROKE_OVER":  "1",

        "AE_LOGO_LAYER": "Logo",
        "AE_LOGO_DIR": "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/Logos-Large",
        "AE_LOGO_PATH_TEMPLATE": "{league}/{abbr}",
        "AE_LOGO_EXTS": "png,jpg,jpeg,svg,ai,psd",
        "AE_LOGO_CASE": "keep",

        "AE_OUTDIR": OUTDIR,
        "AE_PATH_TEMPLATE": PATH_TEMPLATE,
        "AE_ANIM": ANIM_NAME,
        "AE_RS_TEMPLATE": "Best Settings",
        "AE_OM_TEMPLATE": OM_TEMPLATE,
        "AE_EXT": EXT,

        "AE_NO_RENDER": "0",
        "AE_QUIT": "1",
    }
    if league: env["AE_LEAGUE"] = league
    if teams:  env["AE_TEAMS"]  = ",".join(teams)
    return env

if __name__ == "__main__":
    assert os.path.isfile(JSX_BATCH), f"JSX not found: {JSX_BATCH}"
    assert os.path.isfile(PROJECT),   f"Project not found: {PROJECT}"
    assert os.path.isfile(CSV_PATH),  f"CSV not found: {CSV_PATH}"
    assert os.path.isfile(COMMON_JSX),f"Common JSX not found: {COMMON_JSX}"

    if RUN_MODE == "league":
        run(make_env(league=LEAGUE))
    else:
        run(make_env(teams=SUBSET))
